
function [yd,xd,b0,s0]=getdummiesEXO(Y,LAMDAP,EPSILON,L,ex,varargin)
N=cols(Y);

%priors
lamdaP=LAMDAP;  %This controls the tightness of the priors on the first lag
tauP=0;%10*lamdaP;  % this controls the tightness of the priors on sum of coefficients
epsilonP=EPSILON;  % this controls tightness of the prior on the constant
muP=mean(Y)';
sigmaP=[];
deltaP=[];
for i=1:N
    ytemp=Y(:,i);
    xtemp=[lag0(ytemp,1) ones(rows(ytemp),1)];
    ytemp=ytemp(2:end,:);
    xtemp=xtemp(2:end,:);
    btemp=xtemp\ytemp;
    etemp=ytemp-xtemp*btemp;
    stemp=etemp'*etemp/(rows(ytemp)-cols(xtemp));
    if btemp(1)>1;
        btemp(1)=1;
    end
    deltaP=[deltaP;btemp(1)];
    sigmaP=[sigmaP;sqrt(stemp)];
end

if ~isempty(varargin)
    deltaP=varargin{1};
end

%dummy data to implement priors see http://ideas.repec.org/p/ecb/ecbwps/20080966.html
[yd,xd] = create_dummiestrendxx(lamdaP,tauP,deltaP,epsilonP,L,muP,sigmaP,N,ex);


if epsilonP==0
    ex=0;
end
b0=vec(xd\yd);

  b01=reshape(b0,N*L+ex,N);
  e0=yd-xd*b01;
%   S=e0'*e0;
S=diag(sigmaP.^2);
  s0=kron(S,pinv(xd'*xd));